function allvars=makegamefeat(data)

[n m]=size(data);

row=cell(n,1); %Row player's payoff matrix
column=cell(n,1); %Column player's payoff matrix
for i=1:n
    row{i}=[data(i,1) data(i,3) data(i,5);
            data(i,7) data(i,9) data(i,11);
            data(i,13) data(i,15) data(i,17)];
    column{i}=[data(i,2) data(i,4) data(i,6);
            data(i,8) data(i,10) data(i,12);
            data(i,14) data(i,16) data(i,18)];
end

Nash=cell(n,1);
surviveround1=cell(n,1);
surviveround2=cell(n,1);
surviveround3=cell(n,1);
level1=cell(n,1);
for i=1:n
    Nash{i}=NE(row{i},column{i});
    surviveround1{i}=elim(row{i},column{i}); %First cell division into row (1) and column (2); second cell division into surviving action indices (1) and payoff matrix (2)
    surviveround2{i}=elim(surviveround1{i}{1}{2},surviveround1{i}{2}{2});
    surviveround2{i}{1}{1}=surviveround1{i}{1}{1}(surviveround2{i}{1}{1});
    surviveround2{i}{2}{1}=surviveround1{i}{2}{1}(surviveround2{i}{2}{1});
    surviveround3{i}=elim(surviveround2{i}{1}{2},surviveround2{i}{2}{2});
    surviveround3{i}{1}{1}=surviveround2{i}{1}{1}(surviveround3{i}{1}{1});
    surviveround3{i}{2}{1}=surviveround2{i}{2}{1}(surviveround3{i}{2}{1});
    maxpayoffs{i}=maxsum(row{i},column{i});
    level1{i}=BRuniform(row{i},column{i});
    level1_UnD{i}=BRuniform(surviveround1{i}{1}{2},surviveround1{i}{2}{2});
    level2{i}=BRlevelzero(level1{i},row{i},column{i});
    ParetoAct{i}=ParetoAction(row{i},column{i});
    ParetoUndAct{i}=ParetoUndAction(row{i},column{i});
    RangePareto{i}=RangeParetoFrontier(row{i},column{i},ParetoUndAct{i});
    PayRange{i}=PayoffRange(row{i},column{i});
    PayRangeAll{i}=PayoffRangeAll(row{i},column{i});
    MaxUnfair{i}=Unfair(row{i},column{i});
    Highest{i}=HighestPayoff(row{i},column{i});
    PayVar{i}=PayoffVar(row{i},column{i});
    Maxmin{i}=MaxMin(row{i},column{i});
    Fair{i}=MaxFair(row{i},column{i});
    Regret{i}=MinRegret(row{i},column{i});
    FirstAct{i}=First(row{i},column{i});
    Diag{i}=diagonal(row{i});
    level3{i}=levelup(level2{i},row{i},column{i});
    level4{i}=levelup(level3{i},row{i},column{i});
    level5{i}=levelup(level4{i},row{i},column{i});
    level6{i}=levelup(level5{i},row{i},column{i});
    level7{i}=levelup(level6{i},row{i},column{i});
end

for i=1:n
    if isequal(Nash{i},zeros(3,3))==0
        R=reshape(row{i},9,1);
        C=reshape(column{i},9,1);
        NashSet{i}=[R(find(Nash{i}==1)) C(find(Nash{i}==1))];
        ParetoNE{i}=ParetoNash(Nash{i},NashSet{i},row{i},column{i});
        ParetoUndNE{i}=ParetoUnDNash(Nash{i},NashSet{i},row{i},column{i});
        MaxNash{i}=MaxNE(Nash{i},NashSet{i},row{i},column{i});
        NashRange{i}=NERange(NashSet{i});
    else
        ParetoNE{i}=zeros(3,3);
        ParetoUndNE{i}=zeros(3,3);
        MaxNash{i}=zeros(3,3);
        NashRange{i}=zeros(1,2);
    end
end


%% Features

for i=1:n
        IndNE{i}=max(Nash{i},[],2);
        IndMaxPayoff{i}=max(maxpayoffs{i},[],2);
        IndMaxMax{i}=max(maxpayoffs{i},[],2);
        if isempty(ParetoNE{i})==0
            IndParetoNE{i}=max(ParetoNE{i},[],2)';
        %else IndParetoNE{i}=zeros(1,3);
        end
        if isempty(ParetoUndNE{i})==0
            IndParetoUndNE{i}=max(ParetoUndNE{i},[],2)';
        %else IndParetoUndNE{i}=zeros(1,3);
        end
        if isempty(MaxNash{i})==0
            IndMaxNash{i}=max(MaxNash{i},[],2)';
        %else IndMaxNash{i}=zeros(1,3);
        end
        IndParetoAct{i}=max(ParetoAct{i},[],2);
        IndParetoUndAct{i}=max(ParetoUndAct{i},[],2);
end

BestforBoth=zeros(n,1);
for i=1:n
    x=row{i}(:);
    y=column{i}(:);
    if x(find(maxpayoffs{i}))==max(x) & y(find(maxpayoffs{i}))==max(y) 
        BestforBoth(i)=1;
    end
end

RangeMax=zeros(n,1);
for i=1:n
    RangeMax(i)=range([max(row{i}(1,:)),max(row{i}(2,:)),max(row{i}(3,:))]);
end

RangeSum=zeros(n,1);
for i=1:n
    RangeSum(i)=range([sum(row{i}(1,:)),sum(row{i}(2,:)),sum(row{i}(3,:))]);
end

RangeVar=zeros(n,1);
for i=1:n
    RangeVar(i)=range([var(row{i}(1,:)),var(row{i}(2,:)),var(row{i}(3,:))]);
end


RangeMin=zeros(n,1);
for i=1:n
    RangeMin(i)=range([min(row{i}(1,:)),min(row{i}(2,:)),min(row{i}(3,:))]);
end



for i=1:n
    feat_game{i}=[
        NashRange{i}(1);
        PayRange{i}(1); 
        corr(reshape(row{i},9,1),reshape(column{i},9,1));
        sum(sum(Nash{i})); 
        PayVar{i};
        length(surviveround3{i}{1}{1})
        logical(length(level1{i}{1})==1)
        logical(length(surviveround3{i}{1}{1})==1)
        BestforBoth(i)
        RangeMax(i)
        RangeSum(i)
        RangeVar(i)
        RangeMin(i)];
    
end


for i=1:n
    FeaturesMatrix(i,:)=transpose(feat_game{i});
end

%% Descriptions of Features

DescriptionMatrix={
['Range of payoffs in NE for row player'] 
['Range of payoffs for row player']
['Correlation of row and column player payoffs']
['Number of NE']
['Variance of payoff matrix']
['Number of rationalizable actions']
['Existence of unique Level 1 action']
['Existence of a unique action that survives ISD']
['Existence of an action that maximizes both players payoffs']
['Range in best payoff attainable by each action']
['Range in sum of payoffs conditional on action']
['Range in variance of payoffs conditional on action']
['Range in worst payoff attainable by each action']};


%% Interaction Effects
FeaturesMatrixInt=create_interaction_variables(FeaturesMatrix);

        
allvars={FeaturesMatrix,DescriptionMatrix,FeaturesMatrixInt};